/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.network.server;

import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.network.RequestRouter;
import io.gitlab.jfronny.libjf.config.impl.network.packet.ConfigurationCompletePacket;
import io.gitlab.jfronny.libjf.config.impl.network.packet.ConfigurationPacket;
import io.gitlab.jfronny.libjf.config.impl.network.packet.RequestPacket;
import io.gitlab.jfronny.libjf.config.impl.network.packet.ResponsePacket;
import io.gitlab.jfronny.libjf.config.impl.network.rci.entry.Datatype;
import io.gitlab.jfronny.libjf.config.impl.network.rci.entry.MirrorEntryInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;

public class JfConfigNetworkServer {
    public static void initialize() {
        RequestRouter.initialize();
        ServerPlayNetworking.registerGlobalReceiver(RequestPacket.ID, (payload, context) -> {
            if (JfConfigNetworkServer.authenticate(context.player())) {
                RequestRouter.acceptRequest(payload, context.responseSender());
            } else {
                RequestRouter.deny(payload.request(), context.responseSender());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(ResponsePacket.ID, (payload, context) -> {
            if (JfConfigNetworkServer.authenticate(context.player())) {
                RequestRouter.acceptResponse(payload, context.responseSender());
            } else {
                RequestRouter.deny(payload.request(), context.responseSender());
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(ConfigurationCompletePacket.ID, (payload, context) -> context.networkHandler().completeTask(JfConfigNetworkConfigurationTask.KEY));
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ConfigurationPacket.ID)) {
                handler.addTask((class_8605)new JfConfigNetworkConfigurationTask());
            }
        });
        JfConfigNetworkServer.registerRPC();
    }

    public static void registerRPC() {
        ConfigHolder ch = ConfigHolder.getInstance();
        RequestRouter.registerHandler("getRegistered", (buf, followupSender) -> {
            class_2540 resp = PacketByteBufs.create();
            resp.method_34062(ch.getRegistered().keySet(), class_2540::method_10814);
            return resp;
        });
        RequestRouter.registerHandler("isRegistered", (buf, followupSender) -> {
            class_2540 resp = PacketByteBufs.create();
            resp.method_52964(ch.isRegistered(buf.method_19772()));
            return resp;
        });
        RequestRouter.registerHandler("migrateFiles", (buf, followupSender) -> {
            ch.migrateFiles(buf.method_19772());
            return null;
        });
        RequestRouter.registerHandler("load", (buf, followupSender) -> {
            JfConfigNetworkServer.readInstance(ch, buf).load();
            return null;
        });
        RequestRouter.registerHandler("write", (buf, followupSender) -> {
            JfConfigNetworkServer.readInstance(ch, buf).write();
            return null;
        });
        RequestRouter.registerHandler("getPresets", (buf, followupSender) -> {
            class_2540 resp = PacketByteBufs.create();
            resp.method_34062(JfConfigNetworkServer.readCategory(ch, buf).getPresets().keySet(), class_2540::method_10814);
            return resp;
        });
        RequestRouter.registerHandler("runPreset", (buf, followupSender) -> {
            Objects.requireNonNull((Runnable)JfConfigNetworkServer.readCategory(ch, buf).getPresets().get(buf.method_19772())).run();
            return null;
        });
        RequestRouter.registerHandler("getReferencedConfigs", (buf, followupSender) -> {
            class_2540 resp = PacketByteBufs.create();
            resp.method_34062((Collection)JfConfigNetworkServer.readCategory(ch, buf).getReferencedConfigs(), (b, ci) -> {
                b.method_52964(Objects.equals(ch.get(ci.getId()), ci));
                b.method_10814(ci.getId());
            });
            return resp;
        });
        RequestRouter.registerHandler("getCategories", (buf, followupSender) -> {
            class_2540 resp = PacketByteBufs.create();
            resp.method_34062(JfConfigNetworkServer.readCategory(ch, buf).getCategories().keySet(), class_2540::method_10814);
            return resp;
        });
        RequestRouter.registerHandler("getEntries", (buf, followupSender) -> {
            class_2540 resp = PacketByteBufs.create();
            resp.method_34062((Collection)JfConfigNetworkServer.readCategory(ch, buf).getEntries(), (b, s) -> {
                b.method_10814(s.getName());
                if (s.supportsRepresentation()) {
                    Type type;
                    Type type2 = type = s.getValueType();
                    Objects.requireNonNull(type2);
                    Type selector0$temp = type2;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Type.TInt.class, Type.TLong.class, Type.TFloat.class, Type.TDouble.class, Type.TString.class, Type.TBool.class, Type.TEnum.class, Type.TUnknown.class}, (Object)selector0$temp, index$1)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            Type.TInt tInt = (Type.TInt)selector0$temp;
                            b.method_53002(Datatype.INT.ordinal());
                            break;
                        }
                        case 1: {
                            Type.TLong tLong = (Type.TLong)selector0$temp;
                            b.method_53002(Datatype.LONG.ordinal());
                            break;
                        }
                        case 2: {
                            Type.TFloat tFloat = (Type.TFloat)selector0$temp;
                            b.method_53002(Datatype.FLOAT.ordinal());
                            break;
                        }
                        case 3: {
                            Type.TDouble tDouble = (Type.TDouble)selector0$temp;
                            b.method_53002(Datatype.DOUBLE.ordinal());
                            break;
                        }
                        case 4: {
                            Type.TString tString = (Type.TString)selector0$temp;
                            b.method_53002(Datatype.STRING.ordinal());
                            break;
                        }
                        case 5: {
                            Type.TBool tBool = (Type.TBool)selector0$temp;
                            b.method_53002(Datatype.BOOL.ordinal());
                            break;
                        }
                        case 6: {
                            Type.TEnum tEnum = (Type.TEnum)selector0$temp;
                            b.method_53002(Datatype.ENUM.ordinal());
                            b.method_34062(Arrays.stream(tEnum.options()).map(Object::toString).toList(), class_2540::method_10814);
                            break;
                        }
                        case 7: {
                            Type.TUnknown tUnknown = (Type.TUnknown)selector0$temp;
                            b.method_53002(-1);
                        }
                    }
                    if (!(type instanceof Type.TUnknown)) {
                        MirrorEntryInfo.write(b, type, s.getDefault());
                        b.method_53002(s.getWidth());
                        b.method_52940(s.getMinValue());
                        b.method_52940(s.getMaxValue());
                    }
                } else {
                    b.method_53002(-1);
                }
            });
            return resp;
        });
        RequestRouter.registerHandler("fixEntry", (buf, followupSender) -> {
            JfConfigNetworkServer.readEntry(ch, buf).fix();
            return null;
        });
        RequestRouter.registerHandler("resetEntry", (buf, followupSender) -> {
            JfConfigNetworkServer.readEntry(ch, buf).reset();
            return null;
        });
        RequestRouter.registerHandler("getEntryValue", (buf, followupSender) -> {
            class_2540 resp = PacketByteBufs.create();
            EntryInfo entryInfo = JfConfigNetworkServer.readEntry(ch, buf);
            MirrorEntryInfo.write(resp, entryInfo.getValueType(), entryInfo.getValue());
            return resp;
        });
        RequestRouter.registerHandler("setEntryValue", (buf, followupSender) -> {
            EntryInfo entryInfo = JfConfigNetworkServer.readEntry(ch, buf);
            entryInfo.setValue(MirrorEntryInfo.read(buf, entryInfo.getValueType()));
            return null;
        });
    }

    private static ConfigInstance readInstance(ConfigHolder ch, class_2540 buf) {
        LinkedList parentPaths = buf.method_34066(s -> s.method_34066(class_2540::method_19772));
        String id = buf.method_19772();
        if (parentPaths.isEmpty()) {
            return Objects.requireNonNull(ch.get(id));
        }
        parentPaths = new LinkedList(parentPaths);
        ConfigInstance ci = null;
        for (List parentPath : parentPaths) {
            ci = ci == null ? ch.get((String)parentPath.getFirst()) : JfConfigNetworkServer.getReferencedConfig(ci, (String)parentPath.getFirst());
            for (String segment : parentPath.subList(1, parentPath.size() - 1)) {
                ci = Objects.requireNonNull((ConfigCategory)ci.getCategories().get(segment));
            }
        }
        return JfConfigNetworkServer.getReferencedConfig(Objects.requireNonNull(ci), id);
    }

    private static ConfigInstance getReferencedConfig(ConfigCategory category, String id) {
        return category.getReferencedConfigs().stream().filter(s -> s.getId().equals(id)).findFirst().orElseThrow();
    }

    private static ConfigCategory readCategory(ConfigHolder ch, class_2540 buf) {
        ConfigInstance result = JfConfigNetworkServer.readInstance(ch, buf);
        for (String s : buf.method_34066(class_2540::method_19772)) {
            result = Objects.requireNonNull((ConfigCategory)result.getCategories().get(s));
        }
        return result;
    }

    private static EntryInfo readEntry(ConfigHolder ch, class_2540 buf) {
        ConfigCategory cat = JfConfigNetworkServer.readCategory(ch, buf);
        String name = buf.method_19772();
        return cat.getEntries().stream().filter(s -> s.getName().equals(name)).findFirst().orElseThrow();
    }

    private static boolean authenticate(class_3222 player) {
        return player.method_64475(2);
    }

    public record JfConfigNetworkConfigurationTask() implements class_8605
    {
        public static final class_8605.class_8606 KEY = new class_8605.class_8606(ConfigurationPacket.ID.toString());

        public void method_52376(Consumer<class_2596<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)new ConfigurationPacket(RequestRouter.PROTOCOL_VERSION)));
        }

        public class_8605.class_8606 method_52375() {
            return KEY;
        }
    }
}

